<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Просмотр анкеты';
$this->params['breadcrumbs'][] = $this->title;

$this->registerCss("
.profile-view {
    max-width: 1000px;
    margin: 0 auto;
}

.profile-header {
    background: linear-gradient(135deg, #3949ab 0%, #5c6bc0 100%);
    color: white;
    border-radius: 15px;
    padding: 40px;
    margin-bottom: 40px;
    text-align: center;
    box-shadow: 0 10px 30px rgba(57, 73, 171, 0.3);
}

.profile-photo {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    object-fit: cover;
    border: 5px solid white;
    margin-bottom: 20px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.section {
    background: white;
    border-radius: 10px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    animation: slideUp 0.5s ease-out;
}

.section-title {
    color: #3949ab;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 2px solid #e8eaf6;
    font-size: 1.5rem;
    display: flex;
    align-items: center;
}

.section-title i {
    margin-right: 10px;
}

.info-table {
    width: 100%;
    border-collapse: collapse;
}

.info-table tr {
    border-bottom: 1px solid #eee;
}

.info-table tr:last-child {
    border-bottom: none;
}

.info-label {
    width: 30%;
    padding: 15px;
    color: #666;
    font-weight: 500;
    vertical-align: top;
}

.info-value {
    padding: 15px;
    color: #333;
    font-weight: 400;
}

.file-link {
    display: inline-flex;
    align-items: center;
    color: #3949ab;
    text-decoration: none;
    padding: 8px 15px;
    background: #f0f4ff;
    border-radius: 6px;
    transition: all 0.3s ease;
}

.file-link:hover {
    background: #e1e8ff;
    transform: translateY(-2px);
}

.file-link i {
    margin-right: 8px;
}

.status-badge {
    display: inline-block;
    padding: 8px 20px;
    border-radius: 20px;
    font-weight: bold;
    font-size: 14px;
}

.status-new {
    background: #ff9800;
    color: white;
}

.status-review {
    background: #2196f3;
    color: white;
}

.status-accepted {
    background: #4caf50;
    color: white;
}

.actions {
    display: flex;
    gap: 15px;
    justify-content: center;
    margin-top: 40px;
    flex-wrap: wrap;
}

@keyframes slideUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}
");
?>

<div class="profile-view">
    <div class="profile-header">
        <?php if ($model->photo): ?>
            <img src="<?= Url::to(['/uploads/' . $model->photo]) ?>" 
                 class="profile-photo" 
                 alt="Фото сотрудника">
        <?php else: ?>
            <div style="width: 150px; height: 150px; border-radius: 50%; background: rgba(255,255,255,0.2); 
                        display: flex; align-items: center; justify-content: center; margin: 0 auto 20px;">
                <span style="font-size: 3rem;">👤</span>
            </div>
        <?php endif; ?>
        
        <h1><?= Html::encode($user->full_name) ?></h1>
        <p style="opacity: 0.9;">Анкета сотрудника</p>
        
        <?php 
        $statusClass = '';
        switch ($model->status) {
            case 'new': $statusClass = 'status-new'; break;
            case 'in_review': $statusClass = 'status-review'; break;
            case 'accepted': $statusClass = 'status-accepted'; break;
        }
        ?>
        <div class="status-badge <?= $statusClass ?>" style="margin-top: 15px;">
            Статус: <?= $model->getStatusName() ?>
        </div>
    </div>

    <!-- Личные данные -->
    <div class="section">
        <h2 class="section-title">
            <span>👤</span> Личные данные
        </h2>
        
        <table class="info-table">
            <tr>
                <td class="info-label">ФИО</td>
                <td class="info-value"><?= Html::encode($user->full_name) ?></td>
            </tr>
            <tr>
                <td class="info-label">Дата рождения</td>
                <td class="info-value"><?= $model->birth_date ? Yii::$app->formatter->asDate($model->birth_date) : 'Не указана' ?></td>
            </tr>
            <tr>
                <td class="info-label">Пол</td>
                <td class="info-value"><?= $model->getGenderName() ?></td>
            </tr>
            <tr>
                <td class="info-label">Гражданство</td>
                <td class="info-value"><?= Html::encode($model->citizenship) ?></td>
            </tr>
            <tr>
                <td class="info-label">Email</td>
                <td class="info-value"><?= Html::encode($user->email) ?></td>
            </tr>
            <tr>
                <td class="info-label">Телефон</td>
                <td class="info-value"><?= Html::encode($user->phone) ?></td>
            </tr>
        </table>
    </div>

    <!-- Паспортные данные -->
    <div class="section">
        <h2 class="section-title">
            <span>🛂</span> Паспортные данные
        </h2>
        
        <table class="info-table">
            <tr>
                <td class="info-label">Серия и номер</td>
                <td class="info-value">
                    <?= $model->passport_series && $model->passport_number ? 
                        $model->passport_series . ' ' . $model->passport_number : 'Не указаны' ?>
                </td>
            </tr>
            <tr>
                <td class="info-label">Кем выдан</td>
                <td class="info-value"><?= Html::encode($model->passport_issued_by) ?></td>
            </tr>
            <tr>
                <td class="info-label">Дата выдачи</td>
                <td class="info-value"><?= $model->passport_issue_date ? Yii::$app->formatter->asDate($model->passport_issue_date) : 'Не указана' ?></td>
            </tr>
            <tr>
                <td class="info-label">Адрес регистрации</td>
                <td class="info-value"><?= Html::encode($model->passport_registration) ?></td>
            </tr>
            <tr>
                <td class="info-label">Семейное положение</td>
                <td class="info-value"><?= $model->getMaritalStatusName() ?></td>
            </tr>
            <?php if ($model->passport_scan): ?>
            <tr>
                <td class="info-label">Скан паспорта</td>
                <td class="info-value">
                    <a href="<?= $model->getFileUrl('passport_scan') ?>" 
                       target="_blank" 
                       class="file-link">
                        <span>📄</span> Просмотреть скан
                    </a>
                </td>
            </tr>
            <?php endif; ?>
        </table>
    </div>

    <!-- Образование -->
    <div class="section">
        <h2 class="section-title">
            <span>🎓</span> Образование
        </h2>
        
        <table class="info-table">
            <tr>
                <td class="info-label">Уровень образования</td>
                <td class="info-value"><?= $model->getEducationName() ?></td>
            </tr>
            <tr>
                <td class="info-label">Образовательное учреждение</td>
                <td class="info-value"><?= Html::encode($model->education_organization) ?></td>
            </tr>
            <tr>
                <td class="info-label">Специальность</td>
                <td class="info-value"><?= Html::encode($model->specialty) ?></td>
            </tr>
            <tr>
                <td class="info-label">Квалификация</td>
                <td class="info-value"><?= Html::encode($model->qualification) ?></td>
            </tr>
            <tr>
                <td class="info-label">Номер диплома</td>
                <td class="info-value"><?= Html::encode($model->diploma_number) ?></td>
            </tr>
            <?php if ($model->diploma_scan): ?>
            <tr>
                <td class="info-label">Скан диплома</td>
                <td class="info-value">
                    <a href="<?= $model->getFileUrl('diploma_scan') ?>" 
                       target="_blank" 
                       class="file-link">
                        <span>📑</span> Просмотреть скан
                    </a>
                </td>
            </tr>
            <?php endif; ?>
        </table>
    </div>

    <!-- Работа -->
    <div class="section">
        <h2 class="section-title">
            <span>💼</span> Работа
        </h2>
        
        <table class="info-table">
            <tr>
                <td class="info-label">Место работы</td>
                <td class="info-value"><?= Html::encode($model->workplace) ?></td>
            </tr>
            <tr>
                <td class="info-label">Должность</td>
                <td class="info-value"><?= Html::encode($model->position) ?></td>
            </tr>
            <tr>
                <td class="info-label">Стаж работы</td>
                <td class="info-value"><?= $model->getExperienceFormatted() ?></td>
            </tr>
        </table>
    </div>

    <!-- Прочая информация -->
    <div class="section">
        <h2 class="section-title">
            <span>📋</span> Прочая информация
        </h2>
        
        <table class="info-table">
            <tr>
                <td class="info-label">СНИЛС</td>
                <td class="info-value"><?= Html::encode($model->snils) ?></td>
            </tr>
            <?php if ($model->snils_scan): ?>
            <tr>
                <td class="info-label">Скан СНИЛС</td>
                <td class="info-value">
                    <a href="<?= $model->getFileUrl('snils_scan') ?>" 
                       target="_blank" 
                       class="file-link">
                        <span>🆔</span> Просмотреть скан
                    </a>
                </td>
            </tr>
            <?php endif; ?>
            <tr>
                <td class="info-label">Состояние здоровья</td>
                <td class="info-value"><?= nl2br(Html::encode($model->health_status)) ?></td>
            </tr>
            <tr>
                <td class="info-label">Дополнительная информация</td>
                <td class="info-value"><?= nl2br(Html::encode($model->additional_info)) ?></td>
            </tr>
        </table>
    </div>

    <?php if ($model->review_comment): ?>
    <div class="section" style="background: #fff8e1;">
        <h2 class="section-title">
            <span>💬</span> Комментарий администратора
        </h2>
        
        <div style="padding: 20px; background: #fff3cd; border-radius: 8px; color: #856404;">
            <?= nl2br(Html::encode($model->review_comment)) ?>
        </div>
        
        <?php if ($model->reviewed_at): ?>
        <div style="margin-top: 15px; color: #666; font-size: 14px;">
            Проверено: <?= Yii::$app->formatter->asDatetime($model->reviewed_at) ?>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <div class="actions">
        <?= Html::a('← Назад в кабинет', ['index'], [
            'class' => 'btn',
            'style' => 'background: #78909c; color: white; padding: 12px 30px;'
        ]) ?>
        
        <?= Html::a('✏️ Редактировать', ['update'], [
            'class' => 'btn',
            'style' => 'background: #ff9800; color: white; padding: 12px 30px;'
        ]) ?>
        
        <?php if ($model->status !== 'accepted'): ?>
        <?= Html::a('📄 Распечатать', '#', [
            'class' => 'btn',
            'style' => 'background: #2196f3; color: white; padding: 12px 30px;',
            'onclick' => 'window.print(); return false;'
        ]) ?>
        <?php endif; ?>
    </div>
</div>