<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Редактирование анкеты';
$this->params['breadcrumbs'][] = ['label' => 'Личный кабинет', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->registerCss("
.update-container {
    max-width: 900px;
    margin: 0 auto;
}

.update-card {
    background: white;
    border-radius: 10px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.card-header {
    background: linear-gradient(135deg, #ff9800 0%, #ffb74d 100%);
    color: white;
    border-radius: 10px 10px 0 0;
    padding: 20px 30px;
    margin: -30px -30px 30px -30px;
}

.card-header h2 {
    margin: 0;
    font-size: 1.8rem;
}

.section {
    margin-bottom: 40px;
    padding-bottom: 30px;
    border-bottom: 1px solid #eee;
}

.section:last-child {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}

.section-title {
    color: #3949ab;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 2px solid #e8eaf6;
    font-size: 1.5rem;
}

.form-row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -10px;
}

.form-group {
    padding: 0 10px;
    margin-bottom: 20px;
    flex: 1 0 300px;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #444;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    border: 2px solid #ddd;
    border-radius: 6px;
    font-size: 16px;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #3949ab;
    box-shadow: 0 0 0 3px rgba(57, 73, 171, 0.1);
    outline: none;
}

.error-message {
    color: #e53935;
    font-size: 14px;
    margin-top: 5px;
    display: block;
}

.btn {
    display: inline-block;
    padding: 12px 30px;
    border: none;
    border-radius: 6px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(45deg, #3949ab, #5c6bc0);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(57, 73, 171, 0.3);
}

.btn-secondary {
    background: #78909c;
    color: white;
}

.btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(120, 144, 156, 0.3);
}

.file-info {
    font-size: 12px;
    color: #666;
    margin-top: 5px;
    margin-bottom: 10px;
}

.form-actions {
    display: flex;
    justify-content: space-between;
    margin-top: 40px;
    padding-top: 20px;
    border-top: 1px solid #eee;
}

.current-file {
    background: #f5f5f5;
    padding: 10px 15px;
    border-radius: 6px;
    margin-top: 10px;
    font-size: 14px;
}

.current-file a {
    color: #3949ab;
    text-decoration: none;
}

.current-file a:hover {
    text-decoration: underline;
}

.status-info {
    background: #e3f2fd;
    border-left: 4px solid #2196f3;
    padding: 15px 20px;
    margin-bottom: 30px;
    border-radius: 6px;
    color: #1565c0;
}

.status-info p {
    margin: 5px 0;
}

.status-accepted {
    background: #e8f5e9;
    border-left: 4px solid #4caf50;
    color: #2e7d32;
}
");
?>

<div class="update-container">
    <div class="update-card">
        <div class="card-header">
            <h2><span style="margin-right: 10px;">✏️</span>Редактирование анкеты</h2>
        </div>

        <?php if ($model->status === 'accepted'): ?>
        <div class="status-info status-accepted">
            <p><strong>⚠️ Внимание!</strong></p>
            <p>Ваша анкета уже принята администратором. После внесения изменений статус изменится на "Новая" и потребуется повторная проверка.</p>
        </div>
        <?php else: ?>
        <div class="status-info">
            <p><strong>ℹ️ Информация</strong></p>
            <p>После сохранения изменений статус анкеты изменится на "Новая" и потребуется повторная проверка администратором.</p>
        </div>
        <?php endif; ?>

        <?php $form = ActiveForm::begin([
            'id' => 'update-form',
            'options' => ['enctype' => 'multipart/form-data', 'class' => 'form'],
            'fieldConfig' => [
                'template' => "{label}\n{input}\n{error}",
                'labelOptions' => ['class' => 'form-label'],
                'inputOptions' => ['class' => 'form-control'],
                'errorOptions' => ['class' => 'error-message'],
            ],
        ]); ?>

        <!-- Личные данные -->
        <div class="section">
            <h3 class="section-title">Личные данные</h3>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'full_name')->textInput([
                        'value' => $user->full_name,
                        'readonly' => true,
                        'style' => 'background: #f5f5f5;'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'birth_date')->textInput([
                        'type' => 'date',
                        'max' => date('Y-m-d', strtotime('-18 years'))
                    ]) ?>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'gender')->dropDownList($model->getGenderList(), [
                        'prompt' => '-- Выберите пол --'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'citizenship')->textInput([
                        'placeholder' => 'Российская Федерация'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-group">
                <label class="form-label">Фото сотрудника</label>
                <div class="file-info">
                    Форматы: JPG, PNG, PDF | Макс. размер: 10MB
                </div>
                
                <?php if ($model->photo): ?>
                <div class="current-file">
                    <strong>Текущее фото:</strong><br>
                    <a href="<?= Yii::$app->request->baseUrl . '/uploads/' . $model->photo ?>" target="_blank">
                        Просмотреть
                    </a>
                </div>
                <?php endif; ?>
                
                <?= $form->field($model, 'photoFile')->fileInput()->label('Загрузить новое фото (оставьте пустым, чтобы не менять)') ?>
            </div>
        </div>

        <!-- Паспортные данные -->
        <div class="section">
            <h3 class="section-title">Паспортные данные</h3>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'passport_series')->textInput([
                        'placeholder' => '0000'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'passport_number')->textInput([
                        'placeholder' => '000000'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'passport_issued_by')->textInput([
                        'placeholder' => 'ОУФМС России по...'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'passport_issue_date')->textInput([
                        'type' => 'date'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'passport_registration')->textarea([
                    'rows' => 3,
                    'placeholder' => 'Адрес регистрации по месту жительства...'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'marital_status')->dropDownList($model->getMaritalStatusList(), [
                    'prompt' => '-- Выберите семейное положение --'
                ]) ?>
            </div>
            
            <div class="form-group">
                <label class="form-label">Скан паспорта</label>
                <div class="file-info">
                    Форматы: JPG, PNG, PDF | Макс. размер: 20MB
                </div>
                
                <?php if ($model->passport_scan): ?>
                <div class="current-file">
                    <strong>Текущий скан:</strong><br>
                    <a href="<?= Yii::$app->request->baseUrl . '/uploads/' . $model->passport_scan ?>" target="_blank">
                        Просмотреть
                    </a>
                </div>
                <?php endif; ?>
                
                <?= $form->field($model, 'passportScanFile')->fileInput()->label('Загрузить новый скан (оставьте пустым, чтобы не менять)') ?>
            </div>
        </div>

        <!-- Образование -->
        <div class="section">
            <h3 class="section-title">Образование</h3>
            
            <div class="form-group">
                <?= $form->field($model, 'education')->dropDownList($model->getEducationList(), [
                    'prompt' => '-- Выберите уровень образования --'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'education_organization')->textInput([
                    'placeholder' => 'Например: МГУ им. Ломоносова'
                ]) ?>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'specialty')->textInput([
                        'placeholder' => 'Например: Программная инженерия'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'qualification')->textInput([
                        'placeholder' => 'Например: Бакалавр'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'diploma_number')->textInput([
                    'placeholder' => 'Номер диплома'
                ]) ?>
            </div>
            
            <div class="form-group">
                <label class="form-label">Скан диплома</label>
                <div class="file-info">
                    Форматы: JPG, PNG, PDF | Макс. размер: 20MB
                </div>
                
                <?php if ($model->diploma_scan): ?>
                <div class="current-file">
                    <strong>Текущий скан:</strong><br>
                    <a href="<?= Yii::$app->request->baseUrl . '/uploads/' . $model->diploma_scan ?>" target="_blank">
                        Просмотреть
                    </a>
                </div>
                <?php endif; ?>
                
                <?= $form->field($model, 'diplomaScanFile')->fileInput()->label('Загрузить новый скан (оставьте пустым, чтобы не менять)') ?>
            </div>
        </div>

        <!-- Работа и прочее -->
        <div class="section">
            <h3 class="section-title">Работа и дополнительная информация</h3>
            
            <div class="form-row">
                <div class="form-group">
                    <?= $form->field($model, 'workplace')->textInput([
                        'placeholder' => 'Название организации'
                    ]) ?>
                </div>
                
                <div class="form-group">
                    <?= $form->field($model, 'position')->textInput([
                        'placeholder' => 'Должность'
                    ]) ?>
                </div>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'experience')->textInput([
                    'type' => 'number',
                    'min' => 0,
                    'placeholder' => 'Стаж в месяцах'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'snils')->textInput([
                    'placeholder' => '000-000-000 00'
                ]) ?>
            </div>
            
            <div class="form-group">
                <label class="form-label">Скан СНИЛС</label>
                <div class="file-info">
                    Форматы: JPG, PNG, PDF | Макс. размер: 10MB
                </div>
                
                <?php if ($model->snils_scan): ?>
                <div class="current-file">
                    <strong>Текущий скан:</strong><br>
                    <a href="<?= Yii::$app->request->baseUrl . '/uploads/' . $model->snils_scan ?>" target="_blank">
                        Просмотреть
                    </a>
                </div>
                <?php endif; ?>
                
                <?= $form->field($model, 'snilsScanFile')->fileInput()->label('Загрузить новый скан (оставьте пустым, чтобы не менять)') ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'health_status')->textarea([
                    'rows' => 3,
                    'placeholder' => 'Опишите состояние здоровья, хронические заболевания, аллергии и т.д.'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'additional_info')->textarea([
                    'rows' => 4,
                    'placeholder' => 'Дополнительная информация, которую считаете нужной указать...'
                ]) ?>
            </div>
        </div>

        <div class="form-actions">
            <?= Html::a('Отмена', ['index'], [
                'class' => 'btn btn-secondary'
            ]) ?>
            
            <?= Html::submitButton('Сохранить изменения', [
                'class' => 'btn btn-primary',
                'style' => 'background: linear-gradient(45deg, #ff9800, #ffb74d);'
            ]) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>
    
    <div style="text-align: center; margin-top: 20px; color: #666;">
        <p>Все поля обязательны для заполнения, кроме файлов.</p>
        <p>После сохранения анкета будет отправлена на повторную проверку администратору.</p>
    </div>
</div>