<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\LinkPager;

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;

$this->registerCss("
.admin-container {
    max-width: 1400px;
    margin: 0 auto;
}

.admin-header {
    background: linear-gradient(135deg, #1a237e 0%, #283593 100%);
    color: white;
    border-radius: 15px;
    padding: 40px;
    margin-bottom: 40px;
    text-align: center;
    box-shadow: 0 10px 30px rgba(26, 35, 126, 0.3);
    animation: fadeIn 0.8s ease-out;
}

.admin-header h1 {
    font-size: 2.5rem;
    margin-bottom: 15px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin: 30px 0;
}

.stat-card {
    background: white;
    border-radius: 10px;
    padding: 25px;
    text-align: center;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    animation: slideUp 0.6s ease-out;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
}

.stat-icon {
    font-size: 2.5rem;
    margin-bottom: 15px;
    display: block;
}

.stat-number {
    font-size: 2rem;
    font-weight: bold;
    color: #3949ab;
    margin: 10px 0;
}

.stat-label {
    color: #666;
    font-size: 14px;
}

.filters-card {
    background: white;
    border-radius: 10px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    animation: slideUp 0.6s ease-out;
}

.filters-form {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
}

.filter-label {
    font-size: 14px;
    color: #666;
    margin-bottom: 5px;
    font-weight: 500;
}

.filter-select, .filter-input {
    padding: 10px 15px;
    border: 2px solid #ddd;
    border-radius: 6px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.filter-select:focus, .filter-input:focus {
    border-color: #3949ab;
    outline: none;
    box-shadow: 0 0 0 3px rgba(57, 73, 171, 0.1);
}

.table-container {
    background: white;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    animation: slideUp 0.6s ease-out;
}

.profiles-table {
    width: 100%;
    border-collapse: collapse;
}

.profiles-table thead {
    background: #3949ab;
    color: white;
}

.profiles-table th {
    padding: 15px;
    text-align: left;
    font-weight: 600;
    font-size: 14px;
}

.profiles-table tbody tr {
    border-bottom: 1px solid #eee;
    transition: all 0.3s ease;
}

.profiles-table tbody tr:hover {
    background: #f5f7ff;
}

.profiles-table td {
    padding: 15px;
    color: #333;
    font-size: 14px;
}

.status-badge {
    display: inline-block;
    padding: 5px 12px;
    border-radius: 15px;
    font-size: 12px;
    font-weight: bold;
    text-transform: uppercase;
}

.status-new {
    background: #fff3e0;
    color: #e65100;
}

.status-review {
    background: #e3f2fd;
    color: #1565c0;
}

.status-accepted {
    background: #e8f5e9;
    color: #2e7d32;
}

.action-buttons {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
}

.action-btn {
    padding: 6px 12px;
    border-radius: 4px;
    font-size: 12px;
    font-weight: 500;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
}

.btn-view {
    background: #2196f3;
    color: white;
}

.btn-view:hover {
    background: #1976d2;
    transform: translateY(-2px);
}

.btn-status {
    background: #ff9800;
    color: white;
}

.btn-status:hover {
    background: #f57c00;
    transform: translateY(-2px);
}

.export-section {
    text-align: center;
    margin: 40px 0;
    padding: 30px;
    background: #f8f9fa;
    border-radius: 10px;
}

.pagination {
    display: flex;
    justify-content: center;
    margin-top: 30px;
    list-style: none;
    gap: 10px;
}

.pagination li {
    display: inline-block;
}

.pagination a {
    display: inline-block;
    padding: 8px 16px;
    border-radius: 6px;
    background: white;
    color: #3949ab;
    text-decoration: none;
    border: 2px solid #ddd;
    transition: all 0.3s ease;
}

.pagination a:hover {
    border-color: #3949ab;
    background: #f5f7ff;
}

.pagination .active a {
    background: #3949ab;
    color: white;
    border-color: #3949ab;
}

.empty-state {
    text-align: center;
    padding: 60px 30px;
}

.empty-state-icon {
    font-size: 4rem;
    color: #bbb;
    margin-bottom: 20px;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes slideUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}

.search-box {
    position: relative;
    margin-bottom: 20px;
}

.search-input {
    width: 100%;
    padding: 12px 45px 12px 15px;
    border: 2px solid #ddd;
    border-radius: 6px;
    font-size: 16px;
    transition: all 0.3s ease;
}

.search-input:focus {
    border-color: #3949ab;
    outline: none;
    box-shadow: 0 0 0 3px rgba(57, 73, 171, 0.1);
}

.search-button {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: #666;
    cursor: pointer;
    font-size: 18px;
}
");

$this->registerJs("
// Анимация для таблицы
document.querySelectorAll('.profiles-table tbody tr').forEach((row, index) => {
    row.style.animationDelay = (index * 0.1) + 's';
    row.classList.add('animated-row');
});

// Стиль для анимированных строк
const style = document.createElement('style');
style.textContent = '
    @keyframes fadeInRow {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .animated-row {
        animation: fadeInRow 0.5s ease-out forwards;
    }
';
document.head.appendChild(style);

// Быстрый просмотр анкеты
function quickView(profileId) {
    // Здесь можно добавить модальное окно с быстрым просмотром
    window.location.href = '/admin/view?id=' + profileId;
}

// Изменение статуса
function changeStatus(profileId, newStatus) {
    if (confirm('Изменить статус анкеты?')) {
        fetch('/admin/update-status?id=' + profileId + '&status=' + newStatus, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-Token': document.querySelector('meta[name=\"csrf-token\"]').content
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Ошибка при изменении статуса');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Ошибка при изменении статуса');
        });
    }
}

// Экспорт данных
function exportData(format) {
    if (format === 'csv') {
        window.location.href = '/admin/export?format=csv';
    }
}

// Фильтрация таблицы
function filterTable() {
    const searchInput = document.getElementById('search-input').value.toLowerCase();
    const statusFilter = document.getElementById('status-filter').value;
    const rows = document.querySelectorAll('.profiles-table tbody tr');
    
    rows.forEach(row => {
        const name = row.cells[1].textContent.toLowerCase();
        const email = row.cells[2].textContent.toLowerCase();
        const status = row.cells[4].querySelector('.status-badge').textContent.toLowerCase();
        const statusClass = row.cells[4].querySelector('.status-badge').className;
        
        let showRow = true;
        
        // Поиск по имени или email
        if (searchInput && !name.includes(searchInput) && !email.includes(searchInput)) {
            showRow = false;
        }
        
        // Фильтр по статусу
        if (statusFilter && !statusClass.includes(statusFilter)) {
            showRow = false;
        }
        
        row.style.display = showRow ? '' : 'none';
    });
}
");
?>

<div class="admin-container">
    <div class="admin-header">
        <h1><span style="font-size: 2.5rem;">👨‍💼</span><br>Панель администратора</h1>
        <p>Управление анкетами сотрудников и данными системы</p>
    </div>

    <!-- Статистика -->
    <div class="stats-grid">
        <div class="stat-card">
            <span class="stat-icon">📋</span>
            <div class="stat-number"><?= $totalProfiles ?></div>
            <div class="stat-label">Всего анкет</div>
        </div>
        
        <div class="stat-card">
            <span class="stat-icon">🆕</span>
            <div class="stat-number"><?= $newProfiles ?></div>
            <div class="stat-label">Новые анкеты</div>
        </div>
        
        <div class="stat-card">
            <span class="stat-icon">🔍</span>
            <div class="stat-number"><?= $reviewProfiles ?></div>
            <div class="stat-label">На проверке</div>
        </div>
        
        <div class="stat-card">
            <span class="stat-icon">✅</span>
            <div class="stat-number"><?= $acceptedProfiles ?></div>
            <div class="stat-label">Принятые</div>
        </div>
    </div>

    <!-- Фильтры -->
    <div class="filters-card">
        <div class="search-box">
            <input type="text" id="search-input" class="search-input" placeholder="Поиск по ФИО или email..." onkeyup="filterTable()">
            <button class="search-button">🔍</button>
        </div>
        
        <div class="filters-form">
            <div class="filter-group">
                <label class="filter-label">Статус анкеты</label>
                <select id="status-filter" class="filter-select" onchange="filterTable()">
                    <option value="">Все статусы</option>
                    <option value="status-new">Новые</option>
                    <option value="status-review">На проверке</option>
                    <option value="status-accepted">Принятые</option>
                </select>
            </div>
            
            <div class="filter-group">
                <label class="filter-label">Образование</label>
                <select class="filter-select" onchange="filterTable()">
                    <option value="">Все уровни</option>
                    <option value="basic">Основное общее</option>
                    <option value="secondary">Среднее общее</option>
                    <option value="vocational">Среднее профессиональное</option>
                    <option value="higher">Высшее</option>
                </select>
            </div>
            
            <div class="filter-group">
                <label class="filter-label">Пол</label>
                <select class="filter-select" onchange="filterTable()">
                    <option value="">Все</option>
                    <option value="male">Мужской</option>
                    <option value="female">Женский</option>
                </select>
            </div>
            
            <div class="filter-group">
                <label class="filter-label">Должность</label>
                <input type="text" class="filter-input" placeholder="Фильтр по должности..." onkeyup="filterTable()">
            </div>
            
            <div class="filter-group">
                <button class="btn" onclick="location.reload()" style="background: #78909c; color: white; padding: 10px 20px;">
                    Сбросить фильтры
                </button>
            </div>
        </div>
    </div>

    <!-- Таблица анкет -->
    <div class="table-container">
        <table class="profiles-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>ФИО</th>
                    <th>Email</th>
                    <th>Телефон</th>
                    <th>Статус</th>
                    <th>Должность</th>
                    <th>Дата заполнения</th>
                    <th>Действия</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($dataProvider->models) > 0): ?>
                    <?php foreach ($dataProvider->models as $profile): ?>
                    <tr>
                        <td>#<?= $profile->id ?></td>
                        <td><?= Html::encode($profile->user->full_name) ?></td>
                        <td><?= Html::encode($profile->user->email) ?></td>
                        <td><?= Html::encode($profile->user->phone) ?></td>
                        <td>
                            <?php 
                            $statusClass = '';
                            switch ($profile->status) {
                                case 'new': $statusClass = 'status-new'; break;
                                case 'in_review': $statusClass = 'status-review'; break;
                                case 'accepted': $statusClass = 'status-accepted'; break;
                            }
                            ?>
                            <span class="status-badge <?= $statusClass ?>">
                                <?= $profile->getStatusName() ?>
                            </span>
                        </td>
                        <td><?= Html::encode($profile->position) ?></td>
                        <td><?= Yii::$app->formatter->asDate($profile->created_at) ?></td>
                        <td>
                            <div class="action-buttons">
                                <a href="<?= Url::to(['admin/view', 'id' => $profile->id]) ?>" 
                                   class="action-btn btn-view" 
                                   title="Просмотреть">
                                    👁️
                                </a>
                                
                                <?php if ($profile->status !== 'accepted'): ?>
                                <a href="<?= Url::to(['admin/update-status', 'id' => $profile->id, 'status' => 'in_review']) ?>" 
                                   class="action-btn btn-status"
                                   title="Взять в работу"
                                   onclick="return confirm('Взять анкету в работу?')">
                                    🔍
                                </a>
                                
                                <a href="<?= Url::to(['admin/update-status', 'id' => $profile->id, 'status' => 'accepted']) ?>" 
                                   class="action-btn btn-status"
                                   style="background: #4caf50;"
                                   title="Принять"
                                   onclick="return confirm('Принять анкету?')">
                                    ✅
                                </a>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" style="text-align: center; padding: 40px;">
                            <div class="empty-state">
                                <div class="empty-state-icon">📭</div>
                                <h3 style="color: #666; margin-bottom: 15px;">Анкеты не найдены</h3>
                                <p style="color: #888;">Нет анкет для отображения</p>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Пагинация -->
    <?php if ($dataProvider->pagination->pageCount > 1): ?>
    <div style="margin-top: 30px;">
        <?= LinkPager::widget([
            'pagination' => $dataProvider->pagination,
            'options' => ['class' => 'pagination'],
            'linkContainerOptions' => ['class' => 'page-item'],
            'linkOptions' => ['class' => 'page-link'],
            'disabledListItemSubTagOptions' => ['class' => 'page-link'],
        ]) ?>
    </div>
    <?php endif; ?>

    <!-- Экспорт -->
    <div class="export-section">
        <h3 style="color: #3949ab; margin-bottom: 20px;">Экспорт данных</h3>
        <p style="color: #666; margin-bottom: 20px;">Экспортируйте данные анкет в CSV формате</p>
        <button onclick="exportData('csv')" class="btn" style="background: #4caf50; color: white; padding: 12px 30px;">
            📥 Экспортировать в CSV
        </button>
    </div>
</div>